/******************************************************************************************
    Copyright (C) 1997-2014 Andrew F. Neuwald, Cold Spring Harbor Laboratory
    and the University of Maryland School of Medicine.

    Permission is hereby granted, free of charge, to any person obtaining a copy of 
    this software and associated documentation files (the "Software"), to deal in the 
    Software without restriction, including without limitation the rights to use, copy, 
    modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
    and to permit persons to whom the Software is furnished to do so, subject to the 
    following conditions:

    The above copyright notice and this permission notice shall be included in all 
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
    INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
    PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
    LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT 
    OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
    OTHER DEALINGS IN THE SOFTWARE.

    For further information contact:
         Andrew F. Neuwald
         Institute for Genome Sciences and
         Department of Biochemistry & Molecular Biology
         University of Maryland School of Medicine
         801 West Baltimore St.
         BioPark II, Room 617
         Baltimore, MD 21201
         Tel: 410-706-6724; Fax: 410-706-1482; E-mail: aneuwald@som.umaryland.edu
 ******************************************************************************************/

#if !defined(DIRICHLET)
#define DIRICHLET

char Dirichlet[] = "AlphaChar= 20\n\
NumDistr= 30\n\
Number= 0\n\
Mixture= 0.055795\n\
Alpha= 5.623820 0.481113 0.124754 0.062460 0.118077 0.284411 0.143053 0.087388 0.747690 0.139395 0.845185 0.324629 0.117716 0.093709 0.124233 0.137387 0.279846 0.395225 0.885932 0.057486 0.174132\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=  HMM9.4 reestimated in henikoff29.2\n\
Number= 1\n\
Mixture= 0.198333\n\
Alpha= 0.097240 0.005471 0.003205 0.006734 0.003746 0.003890 0.013961 0.004171 0.002200 0.004299 0.006471 0.001146 0.004353 0.008103 0.003849 0.005944 0.005726 0.004993 0.003084 0.002313 0.003580\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=     24\n\
Comment=    Outside\n\
Number= 2\n\
Mixture= 0.043566\n\
Alpha= 1.648336 0.023829 0.013934 0.012948 0.014257 0.421906 0.018266 0.083987 0.038659 0.019853 0.092631 0.024908 0.031479 0.014137 0.027661 0.027184 0.032490 0.024892 0.041667 0.082646 0.601005\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=     26\n\
Comment=     Inside\n\
Number= 3\n\
Mixture= 0.060170\n\
Alpha= 2.595432 0.117351 0.015259 0.440525 0.195041 0.019452 0.219530 0.095984 0.015834 0.142278 0.028625 0.009934 0.552268 0.053604 0.108153 0.072858 0.304358 0.138529 0.024479 0.005610 0.035761\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=     19\n\
Comment=    Outside Alpha\n\
Number= 4\n\
Mixture= 0.065466\n\
Alpha= 3.112271 0.112405 0.015299 0.041992 0.143577 0.017355 0.065060 0.094162 0.051119 0.957191 0.105274 0.043396 0.112270 0.039731 0.271938 0.693003 0.114856 0.110312 0.071237 0.013533 0.038563\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=     21\n\
Comment=     Outside Beta\n\
Number= 5\n\
Mixture= 0.067614\n\
Alpha= 2.053644 0.039915 0.015714 0.003876 0.007658 0.174538 0.008662 0.008224 0.313663 0.008378 0.938104 0.217792 0.006251 0.011212 0.018502 0.012426 0.010659 0.033382 0.176828 0.016182 0.031677\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=     22\n\
Comment=    Inside alpha\n\
Number= 6\n\
Mixture= 0.080724\n\
Alpha= 2.138987 0.090516 0.032917 0.008755 0.012101 0.042163 0.012633 0.002993 0.658515 0.011655 0.247526 0.061134 0.011182 0.010157 0.007020 0.007509 0.019088 0.074634 0.812821 0.002517 0.013153\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=     23\n\
Comment=     Inside beta\n\
Number= 7\n\
Mixture= 0.051030\n\
Alpha= 3.878926 0.212613 0.002947 0.559059 1.785044 0.009678 0.074768 0.041324 0.036414 0.218162 0.063284 0.027827 0.095271 0.068844 0.288903 0.077281 0.125497 0.099941 0.072047 0.003378 0.016644\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=     23\n\
Comment=    Alpha helix\n\
Number= 8\n\
Mixture= 0.103529\n\
Alpha= 1.486325 0.469313 0.057156 0.017299 0.019867 0.016517 0.160405 0.011182 0.023021 0.016540 0.034347 0.017280 0.033944 0.045301 0.024767 0.023238 0.277020 0.141858 0.081256 0.005225 0.010786\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=     23\n\
Comment=    Beta strand\n\
Number= 9\n\
Mixture= 0.062940\n\
Alpha= 8.221215 0.715179 0.055294 0.494091 0.884847 0.126187 0.310833 0.267465 0.192278 0.935286 0.342192 0.161881 0.514109 0.215888 0.648380 0.581568 0.728921 0.548172 0.297174 0.039816 0.161653\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=     23\n\
Comment=    Other\n\
Number= 10\n\
Mixture= 0.012518\n\
Alpha= 38.955630 28.551423 0.565366 0.242785 0.370633 0.279615 1.127849 0.136993 0.487259 0.345378 0.715425 0.324427 0.261380 0.142015 0.242370 0.316670 2.268772 0.798852 1.536125 0.080827 0.161467\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=    A\n\
Number= 11\n\
Mixture= 0.004953\n\
Alpha= 381.562208 2.149109 366.228766 0.549940 0.812886 0.605330 0.642524 0.377657 1.241082 0.566625 1.312284 0.643593 0.606889 0.463728 0.495811 0.744845 1.129828 1.522890 1.018556 0.125079 0.324787\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=    C\n\
Number= 12\n\
Mixture= 0.013849\n\
Alpha= 90.727567 0.813931 0.153343 77.977889 3.273717 0.244497 0.550266 0.426253 0.363032 0.435320 0.467218 0.189072 2.699510 0.218904 0.412865 0.393591 0.800290 0.463748 0.478541 0.094782 0.270799\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   D \n\
Number= 13\n\
Mixture= 0.008388\n\
Alpha= 404.591046 0.977143 0.167497 4.975702 389.900318 0.269287 0.758450 0.432526 0.603705 0.491774 0.525121 0.224202 1.025622 0.252665 1.281901 0.465462 0.695009 0.593938 0.589247 0.112740 0.248739\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=    E \n\
Number= 14\n\
Mixture= 0.008064\n\
Alpha= 83.323671 0.699735 0.356915 0.248401 0.298405 70.903099 0.274453 0.164008 1.087658 0.266923 2.932018 0.608033 0.239392 0.298700 0.182252 0.220602 0.694751 0.348900 1.005581 0.373595 2.120251\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   F \n\
Number= 15\n\
Mixture= 0.032205\n\
Alpha= 32.644869 0.765351 0.077209 0.368746 0.264879 0.081006 28.359185 0.112820 0.111967 0.280642 0.133733 0.078132 0.402902 0.138128 0.143655 0.259640 0.538949 0.212270 0.179714 0.045900 0.090040\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   G \n\
Number= 16\n\
Mixture= 0.005033\n\
Alpha= 35.520823 0.355416 0.137119 0.467091 0.387120 0.436376 0.262389 25.654877 0.185132 0.243692 0.533179 0.239060 1.303876 0.222192 1.527084 0.831638 0.665113 0.456249 0.297451 0.138788 1.176979\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   H \n\
Number= 17\n\
Mixture= 0.007454\n\
Alpha= 101.265474 1.082917 0.271050 0.409281 0.472542 0.849580 0.377526 0.184885 69.024063 0.598499 7.800818 1.866678 0.473517 0.274672 0.377379 0.423457 0.783144 1.106196 14.245904 0.142194 0.501174\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   I \n\
Number= 18\n\
Mixture= 0.009400\n\
Alpha= 150.415980 1.035850 0.255273 0.335033 0.521774 0.174273 0.455559 0.314626 0.603025 135.967644 0.567775 0.279866 0.676166 0.375465 0.488081 6.283625 0.589925 0.694491 0.446145 0.134360 0.217023\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=    K \n\
Number= 19\n\
Mixture= 0.017057\n\
Alpha= 31.896633 0.365681 0.117356 0.094474 0.190144 0.606065 0.122000 0.107932 1.282041 0.207351 25.199568 1.009817 0.125287 0.159630 0.240370 0.246184 0.238785 0.323925 0.997080 0.077319 0.185623\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   L \n\
Number= 20\n\
Mixture= 0.002761\n\
Alpha= 201.346274 0.712631 0.333485 0.300630 0.324298 0.563430 0.391133 0.205108 1.951249 0.425476 4.369939 186.853837 0.327992 0.315732 0.314685 0.279826 0.593169 0.627145 1.456093 0.314694 0.685722\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   M \n\
Number= 21\n\
Mixture= 0.005734\n\
Alpha= 108.343187 0.731447 0.259007 1.520903 0.470773 0.396306 0.746858 1.612452 0.775058 0.854867 0.665266 0.313867 93.066214 0.433071 0.835284 0.618114 2.580476 1.256997 0.640903 0.181901 0.383423\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   N \n\
Number= 22\n\
Mixture= 0.022818\n\
Alpha= 15.153304 0.633388 0.054587 0.172433 0.230885 0.085582 0.187591 0.091974 0.138430 0.250215 0.253461 0.074325 0.138719 11.449895 0.199077 0.190734 0.429432 0.287342 0.212190 0.019469 0.053575\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   P \n\
Number= 23\n\
Mixture= 0.005931\n\
Alpha= 79.417510 1.135613 0.212032 0.423208 2.554108 0.228047 0.338909 2.045075 0.448953 0.842670 1.280101 0.759035 0.831471 0.506769 64.114664 1.184163 0.889219 0.706386 0.541216 0.164123 0.211746\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   Q \n\
Number= 24\n\
Mixture= 0.011491\n\
Alpha= 93.103899 0.704700 0.292530 0.276195 0.305040 0.181184 0.435628 0.671325 0.378059 2.581367 0.618072 0.202844 0.537253 0.440666 0.887793 82.834585 0.605975 0.471126 0.273987 0.191374 0.214197\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=    R \n\
Number= 25\n\
Mixture= 0.008219\n\
Alpha= 47.504796 1.353024 0.331182 0.356189 0.287245 0.244731 0.453584 0.180843 0.303047 0.496251 0.431764 0.223955 0.924407 0.338150 0.290647 0.465415 33.605631 6.615348 0.311773 0.073048 0.218563\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=  0\n\
Comment=   S \n\
Number= 26\n\
Mixture= 0.019050\n\
Alpha= 14.027470 0.346760 0.100721 0.118614 0.106944 0.084179 0.102963 0.069036 0.243737 0.182186 0.176427 0.140909 0.323226 0.092498 0.154742 0.157160 1.511636 9.683744 0.349794 0.027197 0.054998\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   T \n\
Number= 27\n\
Mixture= 0.007047\n\
Alpha= 76.958153 3.443787 0.565277 0.443631 0.620026 0.549626 0.456661 0.320631 5.299280 0.549711 1.963319 0.616210 0.386082 0.486873 0.378636 0.625644 0.770151 1.848024 57.336528 0.097154 0.200904\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   V \n\
Number= 28\n\
Mixture= 0.003957\n\
Alpha= 150.973331 0.781050 0.322080 0.529381 0.589245 2.783797 0.632865 0.357128 0.610281 0.635594 2.587769 0.572292 0.549084 0.371185 0.584972 0.757939 0.703043 0.629986 0.937510 134.141760 1.896369\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   W \n\
Number= 29\n\
Mixture= 0.004904\n\
Alpha= 30.653224 1.048491 0.248264 0.388841 0.535514 4.782927 0.362531 1.322202 0.627629 0.504059 1.114747 0.397914 0.404581 0.315841 0.356299 0.487485 0.882175 0.539935 0.765902 0.404148 15.163739\n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=    0\n\
Comment=   Y \n\n";

char Dirichlet9[] = "AlphaChar= 20\n\
NumDistr= 9\n\
Number= 0\n\
Mixture= 0.165255\n\
Alpha= 5.375137 0.350158 0.062540 0.313531 0.486489 0.155920 0.198998 0.142640 0.277031 0.671117 0.358120 0.155367 0.259968 0.162108 0.295920 0.462178 0.277975 0.266069 0.309437 0.045990 0.123581 \n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=  18\n\
Comment=  foo\n\
Number= 1\n\
Mixture= 0.187210\n\
Alpha= 3.769894 0.524292 0.105146 0.156265 0.169372 0.079877 0.416113 0.095649 0.186722 0.180663 0.195640 0.094528 0.146151 0.166505 0.149357 0.132676 0.373411 0.270619 0.246162 0.016012 0.064733 \n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=  19\n\
Comment=  foo\n\
Number= 2\n\
Mixture= 0.059553\n\
Alpha= 11.967290 0.507409 0.287146 0.103692 0.130821 0.229783 0.147500 0.011614 2.561122 0.122442 1.018738 0.413304 0.119400 0.120749 0.160418 0.099077 0.234425 0.361644 5.044144 0.067081 0.226780 \n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=  20\n\
Comment=  foo\n\
Number= 3\n\
Mixture= 0.133161\n\
Alpha= 14.103930 0.821072 0.235716 0.462649 0.790104 0.492263 0.361984 0.399981 1.539390 1.034570 1.605637 0.519196 0.503161 0.282099 0.608428 0.650910 0.746745 0.906839 1.641919 0.121962 0.379304 \n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=  21\n\
Comment=  foo\n\
Number= 4\n\
Mixture= 0.148326\n\
Alpha= 9.736273 0.964985 0.120870 1.052710 0.940649 0.135976 0.833259 0.331830 0.149853 0.792586 0.232871 0.124862 0.664137 0.306990 0.556966 0.375454 0.918317 0.750916 0.295928 0.042548 0.144567 \n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=  22\n\
Comment=  foo\n\
Number= 5\n\
Mixture= 0.084859\n\
Alpha= 29.305956 1.660942 0.391746 2.193530 3.657436 0.541165 0.999516 0.988522 0.731320 3.429023 1.257318 0.649774 1.551058 0.526164 2.286652 2.593831 2.506659 1.685211 0.825378 0.182538 0.648175 \n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=  23\n\
Comment=  foo\n\
Number= 6\n\
Mixture= 0.057945\n\
Alpha= 6.492116 0.317838 0.195864 0.047453 0.118150 1.476816 0.082984 0.235573 0.305670 0.175353 0.512725 0.322566 0.103076 0.075620 0.087281 0.151094 0.257557 0.305938 0.424665 0.266887 1.029006 \n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=  24\n\
Comment=  foo\n\
Number= 7\n\
Mixture= 0.077353\n\
Alpha= 0.856339 0.077495 0.018342 0.061093 0.068490 0.032483 0.070122 0.050204 0.044717 0.049124 0.045069 0.013177 0.027900 0.025033 0.028335 0.033243 0.072849 0.055295 0.050486 0.007013 0.025869 \n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=  25\n\
Comment=  foo\n\
Number= 8\n\
Mixture= 0.086338\n\
Alpha= 7.260940 0.270522 0.171674 0.033837 0.050035 0.497747 0.068582 0.038142 1.026629 0.045454 3.090252 0.557374 0.032322 0.054420 0.065074 0.042640 0.151727 0.193605 0.741541 0.030533 0.098832 \n\
FullUpdate= 1\n\
QUpdate= 1\n\
StructID=  26\n\
Comment=  foo\n\n";

// Order for Dirichlet20[] =  A C D E F G H I K L M N P Q R S T V W Y

char Dirichlet20[] = "AlphaChar= 20\n\
AlphaChar= 20\n\
NumDistr= 20\n\
Number= 0\n\
Mixture= 0.176513\n\
Alpha= 10.1329 0.668781 0.072626 1.08101 0.930936 0.1235 0.982387 0.366701 0.0586812 0.849019 0.185073 0.0648062 0.979541 0.519704 0.555784 0.636552 1.04987 0.60931 0.129148 0.0676805 0.201772\n\
Comment= N , D S Q H K E G R T P >< A Y , W C F M , L V , I\n\
Number= 1\n\
Mixture= 0.207622\n\
Alpha= 11.6836 0.880009 0.197393 0.303744 0.497357 0.657492 0.391988 0.348159 0.936094 0.527206 1.42844 0.449302 0.368825 0.384576 0.439775 0.581516 0.622624 0.747064 1.08007 0.235012 0.606928\n\
Comment= M Y L F I W V H T Q >< R A C S K N P E , G D\n\
Number= 2\n\
Mixture= 0.0669246\n\
Alpha= 5.22319 0.153384 0.0520756 0.0073824 0.0158439 0.428964 0.025533 0.0185789 0.845361 0.0282996 2.42256 0.424296 0.0190716 0.0313429 0.0274578 0.0252186 0.028514 0.0519217 0.522946 0.0279653 0.0664755\n\
Comment= L , M I , F V >< C , A Y W , T H Q P , R K S N G , E , D\n\
Number= 3\n\
Mixture= 0.0868259\n\
Alpha= 9.82176 0.794007 0.0130659 0.624236 1.85769 0.0290214 0.115707 0.123504 0.22099 1.52605 0.341371 0.111114 0.308302 0.263545 0.953727 0.933444 0.554741 0.604551 0.396451 0.00823516 0.0420054\n\
Comment= E K Q , R T D A >< S N P V H M , L I , G , Y C F , W\n\
Number= 4\n\
Mixture= 0.0593123\n\
Alpha= 5.54386 0.740015 0.187165 0.0213261 0.0456854 0.118944 0.0633687 0.0170331 1.06684 0.0380614 0.733524 0.138456 0.0300644 0.0718692 0.0240143 0.0301022 0.0862989 0.367283 1.70735 0.0113856 0.045079\n\
Comment= V , I , C A L T M >< F , P S , Y G W E H , N K Q R D\n\
Number= 5\n\
Mixture= 0.0358616\n\
Alpha= 4.66847 0.15978 0.0261585 0.0505181 0.125524 0.0350331 0.102549 0.157461 0.0795041 1.26261 0.189383 0.0550608 0.171028 0.0844169 0.290476 1.44604 0.129158 0.138972 0.0851144 0.0159134 0.0637679\n\
Comment= R K ,, Q H >< N T M , S L A E P Y C G I V , W D F\n\
Number= 6\n\
Mixture= 0.03427\n\
Alpha= 5.9237 0.308434 0.0137217 1.69731 1.92422 0.0361113 0.162357 0.07232 0.0487895 0.236135 0.0809074 0.0286236 0.213663 0.181631 0.320245 0.104878 0.218398 0.141668 0.0747719 0.0141705 0.0453433\n\
Comment= E D ,, Q >< N K A P S , H T G R , M Y V W L F I C\n\
Number= 7\n\
Mixture= 0.0428319\n\
Alpha= 0.0441636 0.00260287 9.99856e-06 0.00631292 0.00445502 0.00274753 1.03886e-05 1.02839e-05 0.000913052 0.0029241 0.00353485 0.00105128 0.00338172 1.04172e-05 0.00173574 0.00459583 0.00274255 0.00247625 0.00175366 1.02411e-05 0.00288489\n\
Comment= D R , Y N E F K M Q T S >< L A V , I ,,,,, W C H , P , G\n\
Number= 8\n\
Mixture= 0.047875\n\
Alpha= 3.87573 1.61043 0.15522 0.0378292 0.0498243 0.0406484 0.529136 0.0217524 0.040597 0.0413396 0.100193 0.0509779 0.0357917 0.0931204 0.0367156 0.0330646 0.529587 0.196607 0.230878 0.00909518 0.0329275\n\
Comment= A , S C , G >< T V M P , L Q F , Y H N E K I R D W\n\
Number= 9\n\
Mixture= 0.0466614\n\
Alpha= 4.02936 0.15525 0.0136827 0.0857138 0.0508316 0.0151451 3.10555 0.027169 0.0140491 0.0654038 0.0257501 0.00901049 0.127437 0.0423873 0.0345064 0.0477247 0.12452 0.0341196 0.0230637 0.00930115 0.0187464\n\
Comment= G ,,,>< N S A , D K H , R Q P E C T W Y , M F V L , I\n\
Number= 10\n\
Mixture= 0.0283695\n\
Alpha= 4.37516 0.225739 0.0684326 0.101072 0.0813791 0.0298832 0.0915218 0.0336807 0.0833114 0.0931673 0.0731542 0.0419314 0.230216 0.087446 0.0694702 0.0751969 1.13857 1.63158 0.179083 0.00912576 0.0311963\n\
Comment= T S ,, N >< C A V , M Q P D K R I H E G , Y L F W\n\
Number= 11\n\
Mixture= 0.0301127\n\
Alpha= 5.10487 1.3431e-06 0.0166656 0.00743068 1.34592e-06 0.169076 0.00407061 0.00714122 1.98221 0.017522 0.816669 0.114773 0.00678027 0.0106392 0.0100244 0.0158968 0.00879658 0.0399043 1.81043 0.0150671 0.0517801\n\
Comment= I V ,, L M >< F , Y , W C T ,, R K H Q P , N S D , G ,,,,,,,,,,, E , A\n\
Number= 12\n\
Mixture= 0.0233828\n\
Alpha= 3.08488 0.063525 0.0288391 1.09265 0.0959581 0.00965196 0.216914 0.0730986 0.0207325 0.08719 0.0315107 0.00960293 0.752755 0.059914 0.0445321 0.0312317 0.287327 0.116896 0.0249446 0.00701663 0.0305859\n\
Comment= D N ,, S >< H G T C , K E P Q Y A , R W M , V L I F\n\
Number= 13\n\
Mixture= 0.034662\n\
Alpha= 5.72698 0.294281 0.019271 0.12293 0.162747 0.0373667 0.145029 0.0412349 0.0815261 0.157594 0.151631 0.021412 0.0601581 3.6966 0.0809085 0.101856 0.23533 0.135424 0.140532 0.00900473 0.0321389\n\
Comment= P ,,,>< S A , K E T Q D R V G H L , N I C M Y F , W\n\
Number= 14\n\
Mixture= 0.0270202\n\
Alpha= 3.67648 0.0844832 0.0584945 0.0411628 0.045719 0.847822 0.0590839 0.250253 0.0675757 0.0562614 0.168617 0.0439737 0.0794234 0.028301 0.0305672 0.0598024 0.0798202 0.0585385 0.0858243 0.227395 1.30336\n\
Comment= Y , F W , H ,>< C M L , N S V R I A T K , Q G E D P\n\
Number= 15\n\
Mixture= 0.0226822\n\
Alpha= 3.08684 0.0634034 0.0246167 1.3443e-06 0.00389272 1.12953 0.00796028 1.35032e-06 0.233395 1.34466e-06 0.541933 0.101309 1.36412e-06 0.027467 0.00704479 0.00802297 0.0248977 0.0276933 0.185467 0.183309 0.516892\n\
Comment= F , Y , W , L M I >< V , C A , P T S ,, Q R G , E ,,,,,,,,,, H , N K , D\n\
Number= 16\n\
Mixture= 0.00898452\n\
Alpha= 2.51284 0.123696 0.0454619 0.0386434 0.351847 0.0560181 0.0439442 0.223229 0.01302 0.148699 0.19001 0.120964 0.098734 5.90055e-06 0.554971 0.219233 0.0453885 0.0564686 0.0614792 0.0410248 0.0800036\n\
Comment= Q , H E M , R W K >< C N Y L A F , T V S D , G , I ,,,,,,,,,,, P\n\
Number= 17\n\
Mixture= 0.00716226\n\
Alpha= 3.39257 0.0212037 3.18769 0.00745627 0.00382411 0.00691924 0.0126233 1.34375e-06 0.00724293 0.00522979 0.00785563 0.00489521 0.0105326 0.0136265 0.00505819 0.00677712 0.0251744 0.0235516 0.0371462 0.00187667 0.0038893\n\
Comment= C ,,,,,><,, V T , S P A N M , G F Q R D W I Y , K L E ,,,,,,,,,, H\n\
Number= 18\n\
Mixture= 0.00710292\n\
Alpha= 2.51689 0.0229376 0.00427768 0.00959934 0.013608 0.182277 0.0227654 0.0157344 0.0226783 0.011561 0.0803491 0.0154283 0.00899225 0.00980608 0.00600945 0.0342359 0.0216842 0.0189306 0.0223176 1.83914 0.154565\n\
Comment= W ,,,,, F Y ><, L M R H , I S T , V G A C E P N K D Q\n\
Number= 19\n\
Mixture= 0.00582299\n\
Alpha= 1.35874 2.16602e-06 2.16245e-06 0.0198496 2.17942e-06 0.0246741 2.47051e-06 1.02563 0.0131152 2.16539e-06 0.00637704 2.1414e-06 0.0839371 0.0168135 0.0438887 0.0252951 0.0235533 0.0130626 0.00797507 2.16433e-06 0.0545531\n\
Comment= H ,,,, N Y >< Q , F R S P D , T I , V , L ,,,,,,,,, W C M ,, K E G A\n";

#endif


